using System;
using System.Collections;
using System.IO;
using DynaPDF;

namespace examples
{
	class Class1
	{
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write(string.Format("{0}", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage)));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		[STAThread]
		static void Main(string[] args)
		{
		   try
		   {
		      double y, b;
		      int act, f;
            CPDF pdf = new CPDF();
            pdf.SetOnErrorProc(IntPtr.Zero, new TErrorProc(PDFError));

            pdf.CreateNewPDF(null);

            pdf.SetPageCoords(TPageCoord.pcTopDown);

            pdf.Append();
               pdf.SetFont("Helvetica", TFStyle.fsRegular, 12.0, false, TCodepage.cp1252);
               pdf.SetLeading(12.0);
               pdf.WriteFTextEx(50.0, 50.0, pdf.GetPageWidth() - 100.0, -1.0, TTextAlign.taJustify,
                  "The six text fields share the same value. Such an array of fields is called a field group. All fields in the group must be of the same type.\n\n" +
                  "A field group can be created in two different ways: either create two or more fields with the same name or pass the handle of the y field as Parent to the children. " +
                  "The latter way is more efficient since it is not required to search for the parent field when a child will be created.\n\n" +
                  "Enter some more text into a field to see the difference between auto size and fixed font size.");

               // GetLastTextPosY() returns bottom up coordinates. We must subtract the value from the page height.
               b = pdf.GetPageHeight() - pdf.GetLastTextPosY() + 20.0;

               pdf.WriteFTextEx(50.0, b, 200.0, -1.0, TTextAlign.taLeft, "Font size <= 1.0 means auto size.");

               y = pdf.GetPageHeight() - pdf.GetLastTextPosY() + 10.0;

               pdf.ChangeFontSize(1.0);
               f = pdf.CreateTextField("Auto", -1, false, 0, 50.0, y, 200.0, 20.0);
               pdf.SetTextFieldValue(f, "Some text...", "Some text...", TTextAlign.taLeft);

               y += 30.0;
               pdf.CreateTextField(null, f, false, 0, 50.0, y, 200.0, 30.0);

               y += 40.0;
               pdf.CreateTextField(null, f, false, 0, 50.0, y, 200.0, 40.0);

               pdf.ChangeFontSize(12.0);
               pdf.WriteFTextEx(345.0, b, 200.0, -1.0, TTextAlign.taLeft, "The same fields with a fixed font size.");

               y = pdf.GetPageHeight() - pdf.GetLastTextPosY() + 10.0;

               pdf.ChangeFontSize(12.0);
               pdf.CreateTextField(null, f, false, 0, 345.0, y, 200.0, 20.0);

               y += 30.0;
               pdf.ChangeFontSize(24.0);
               pdf.CreateTextField(null, f, false, 0, 345.0, y, 200.0, 30.0);

               y += 40.0;
               pdf.ChangeFontSize(34.0);
               pdf.CreateTextField(null, f, false, 0, 345.0, y, 200.0, 40.0);

               pdf.ChangeFontSize(18.0);
               f = pdf.CreateButton("Reset", "Reset", -1, 222.5, y + 80.0, 150.0, 25.0);
               pdf.SetFieldColor(f, TFieldColor.fcBackColor, TPDFColorSpace.csDeviceRGB, CPDF.PDF_LTGRAY);
               pdf.SetFieldBorderStyle(f, TBorderStyle.bsBevelled);

               act = pdf.CreateResetAction();
               pdf.AddActionToObj(TObjType.otField, TObjEvent.oeOnMouseUp, act, f);
            pdf.EndPage();

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process p = new System.Diagnostics.Process();
                  p.StartInfo.FileName = filePath;
                  p.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
